function [Segmat] = get_segmentation(allspots,Nmask,Ith)
% This function identify and segment regions of interest (ROIs) from raw 
% frames that contain the emission of single emitters.
%
% (Local)-maxima finder with ordfilt2 by, (1) using a Nmask-by-Nmask domain
% that does not include the center pixel, (2) selecting the largest
% (Nmask^2-1) value and (3) comparing to the center value
%
% NOTE: this method only find a single pixel peak. If any neighbors have
% the same (exact) value, it will not be a peak.
%
% Author: Rasmus . Thorsen 
%

% localization mask; 
locmask = ones(Nmask); 
locmask(round(Nmask^2/2)) = 0;

% thresholding the raw frames based on the maximum pixel intensity
allspots((allspots<max(max(allspots))*Ith)) = 0; 

% segmenation matrix
Segmat = ordfilt2(allspots,Nmask^2-1,locmask); 

% figure;imagesc(allspots)
% figure;imagesc(Segmat)
% figure;imagesc(bwareaopen(allspots,50,8))
%%
end